
/******************************************************************************************************
 **                                                                                                  **
 **                         Ex-Read Time LCD (for Test ET-Mini Clock4)                               **
 **                                                                                                  **
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : ATMEL AVR-MEGA88 (ET-Easy 328 Stamp )                                      **
 **       	            : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.1                                                              **
 **                                                                                                  **										
 **  Port Interface     :    Arduino Mega88 PIN                       LCD16x2                        **
 **                         ----------------------                    ----------                     **
 **                 LCD :                                                                            **
 **                           PIN D8(Out)             Connect          RS                            **
 **                               Gnd                 Connect          R/W                           **     
 **                               D9(Out)             Connect          EN                            **  
 **                               D4-D7(Out)          Connect          Data 4 bit High(DB4-DB7)      **
 **                                                                                                  **
 **               RS232  :   PIN D0(Rx0)              Connect          Tx-MiniClock4                 **                              
 **                          Baud Rate 9600                                                          **
 **                                                                                                  ** 
 *--------------------------------------------------------------------------------------+            **
 ** Recive Cmm 9 Byte    : Byte0| Byte1| Byte2| Byte3| Byte4| Byte5| Byte6| Byte7| Byte8|            **                            
 **                        -----+------+------+------+------|------+------+------+------+            **
 ** data Pagate(Decimal) :  '$' | hour |minute|  sec |  day | date | mont | year | '#'  |            **
 **                             | 0-23 |0-59  | 0-59 | 1-7  | 1-31 | 1-12 | 00-99|      |            ** 
 **-------------------------------------------------------------------------------------+            **
 **                                                                                                  ** 
 **        5V                                                                                        **
 **      --+--                                                                                       **
 **        |                                                                                         **
 **        +-----------------+                                               5V                      **
 **        |                 |                                              --+--                    **
 **       ---                |                                                |                      **
 **       |\|                |                                                |                      **
 **    VR |/|<---------------|--+                                             |                      **
 **   10K ---                |  |  D8  Gnd  D9             D4  D5  D6  D7     |       Not use       **
 **        |                 |  |   ^   ^   ^              ^   ^   ^   ^      |         ^            **
 **        |                 |  |   |   |   |              |   |   |   |      |         |            **
 **        +--------------+--|--|---|---|---|--+--+--+--+  |   |   |   |      \         |            **
 **      __|__            |  |  |   |   |   |  |  |  |  |  |   |   |   |      / 10      |            **
 **       ---             |  |  |   |   |   |  |  |  |  |  |   |   |   |      \         \            **
 **        -             1| 2| 3|  4|  5| 6 | 7| 8| 9|10|11|12 | 13| 14|      /         /            **
 **                     __|__|__|___|___|___|__|__|__|__|__|___|___|___|_    |          \ 1K         **
 **                    |  G Vcc Vo RS  R/W  E  D0 D1 D2 D3 D4  D5  D6 D7 |   |          /            **
 **                    |    _________________________________________    |   |          |            **
 **                    |   |                                         | A |---+          |            **
 **                    |   |               Module                    |   |       C      |            **
 **                    |   |         LCD 16x2 Charecter              | K |---------\| B |            **  
 **                    |   |_________________________________________|   |          |---+            **
 **                    |Row0 # # # # # # # #  |RoW1    # # # # # # # #   |         /|                **
 **                    |address 0-7           |Address 0 1 2 3 4 5 6 7   |       \|/                 ** 
 *                     |_________________________________________________|      E |  BC337           **
 **                                                                             __|__                **
 **                                                                              ---                 **
 **                                                                               -                  **
 **  Create By          : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                       **
 **  Last Update        : 18/August/2017                                                             ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

#include <LiquidCrystal.h>



//************** Define LCD ******************

const int rs=8,en=9,d4=4,d5=5,d6=6,d7=7;

LiquidCrystal LCD(rs,en,d4,d5,d6,d7)   ;  //RW=Gnd : 4bit ;

   
unsigned char rxd[13],rx_cnt=0   ;
unsigned char fag_rx = 0         ;


//*********** Function Receive Data Time form RS232 of Clock  *************

void Rx_Cmm()
 {
     unsigned char ch  ;
  
     if(Serial.available() > 0)       // Check when receive data:
      {                
        ch = Serial.read()         ;    //Read data byte
          
        if(ch =='$')                    //Check Start Byte Data Command = '$'    
            fag_rx = 1             ;    //Enable fag_rx Keep Data   

        if(fag_rx == 1)                 // Check fag_rx ==1 keep data
           {
             rxd[rx_cnt] = ch       ;   //Keep data '$'  array[0]
             rx_cnt++               ;   //Increment Array for keep next data
           }
           

     //---- Check End Byte Command--------
           if(ch == '#')            // if data End byte= '#'
           {
               rx_cnt = 0       ;    //Clear counter Array for keep data
            
              fag_rx = 0        ;   //Clead Fag_rx            
           }//if ch

      }  //if serial
 }



/*##########################################################################
 ##                                                                       ##
 ##                               SETUP                                   ##
 ##                                                                       ##
 ##########################################################################*/

void setup() 
{

  Serial.begin(9600)             ;   //Setup Uart Baudrate 9600
  
  //-------------------- SetUp LCD16x2 ----------------------
  
  LCD.begin(16,2)                 ;    //Set up the LCD's number of columns(16 colum) and rows(2-Row) 
  LCD.clear()                     ;    //Clear Display
 
} 

/*#######################################################################
 ##                                                                    ##
 ##                        MAIN PROGRAM                                ##
 ##                                                                    ##
 ########################################################################*/

void loop() 
{  
  unsigned char sec_old=0,dt_old=0  ; 
     
    while(1)
     { 
       Rx_Cmm() ;

       if(rxd[0] =='$')
        { 
          if(rxd[8] == '#')
           {
             rxd[0]  = 0  ;
             rxd[8]  = 0  ;

            //########### Print Time to LCD ##############
            
             if(sec_old != rxd[3])               //Check  Secound chang update time
              {
                LCD.setCursor(4,0)               ;      //Set Cursor Start Colum4,Row0
      
               //----Print Hour to LCD -----
                if(rxd[1] <10) 
                  LCD.print (0)                  ;     //print 0 front side if Hour <10       
                LCD.print (rxd[1])               ;      //Hour
                
                LCD.print (':')  ;

               //----Print Minuit to LCD ------
                if(rxd[2] <10)
                  LCD.print (0)                  ;     //print 0 front side if Minuit <10       
                LCD.print (rxd[2])               ;     //Miniit
               
                LCD.print (':')  ;
        
               //----Print Secound to LCD ------
               
                if(rxd[3] <10)
                  LCD.print (0)                  ;     //print 0 front side if sec <10                
                LCD.print (rxd[3])               ;     //Secound

         
                sec_old = rxd[3]                 ;
             

             //############ Print Date to LCD #################

        
               LCD.setCursor(4,1)               ;      //Set Cursor Start Colum4,Row1
      
               //----Print Date to LCD -----
                if(rxd[5] <10) 
                  LCD.print (0)                  ;     //print 0 front side if Date <10       
                LCD.print (rxd[5])               ;      //Hour
                
                LCD.print ('/')  ;

               //----Print Month to LCD ------
                if(rxd[6] <10)
                  LCD.print (0)                  ;     //print 0 front side if Month <10       
                LCD.print (rxd[6])               ;     //Miniit
               
                LCD.print ('/')  ;
        
               //----Print Year to LCD ------
               
                if(rxd[7] <10)
                  LCD.print (0)                  ;     //print 0 front side if year <10                
                LCD.print (rxd[7])               ;     //Secound

           
   
            } //if sec_old
          
          } //if rxd8
      
       }//if rxd0
  
    }  //while

} //end loop

